create or replace package tbicds.PCK_ENCOUNTER_INTAKE
AUTHID CURRENT_USER
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  --custom to return recordsets
  type RetRefCursor is ref cursor;

  function GetPiece(strData      in varchar2,
                    strDelimiter in varchar2,
                    nPosition    in NUMBER) return varchar2;

  procedure GetEncounterFlags(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vEncounterID     in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out Pck_Utl_Common.refCursor);

  procedure GetEncounterIntakeFlags(pi_vSessionID         in varchar2,
                                    pi_vSessionClientIP   in varchar2,
                                    pi_nUserID            in number,
                                    pi_vEncounterID       in varchar2,
                                    pi_vEncounterIntakeID in number,
                                    po_nStatusCode        out number,
                                    po_vStatusComment     out varchar2,
                                    rs                    out Pck_Utl_Common.refCursor);

  procedure getIntakeAltLang(pi_vSessionID         in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vEncounterID       in varchar2,
                             pi_nEncounterIntakeID in number,
                             po_nOutAltLang        out number,
                             po_nStatusCode        out number,
                             po_vStatusComment     out varchar2);

  procedure getIntakePatientID(pi_vSessionID         in varchar2,
                               pi_vSessionClientIP   in varchar2,
                               pi_nUserID            in number,
                               pi_vEncounterID       in varchar2,
                               pi_nEncounterIntakeID in number,
                               po_vPatientID         out varchar2,
                               po_nStatusCode        out number,
                               po_vStatusComment     out varchar2);

  -----------------------------------------------------------
  -- Tries to retrieve the encounter ID for the passed MID.
  -- If there is no encounter, it inserts a new encounter
  -- of type 7 (patient intake session)
  -----------------------------------------------------------
  procedure GetEncounterIDFromModule(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_nModuleID        in number,
                                     pi_vPatientID       in varchar2,
                                     pi_nTreatmentID     in number,
                                     po_vEncounterID     out varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2);

  -- Checks to see if there is an encounter_intake for the module
  -- if not, it inserts new one
  procedure NewEncounterIntake(pi_vSessionID         in varchar2,
                               pi_vSessionClientIP   in varchar2,
                               pi_nUserID            in number,
                               pi_nModuleID          in number,
                               pi_vEncounterID       in varchar2,
                               pi_nAltLang           in number,
                               po_nEncounterIntakeID out number,
                               po_nStatusCode        out number,
                               po_vStatusComment     out varchar2);

  --get all Encounter Intake Responses
  procedure GetResponsesCountRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vEncounterID     in varchar2,
                                pi_vMIDs            in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  procedure GetIntakesForEducationRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_vPatientID       in varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor);

  procedure GetIntakesForReviewRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  pi_vEncounterID      in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

end;
/

